//******************************************************************************
//  MSP-FET430P440 Demo - ADC12, Sample A10 Temp and Convert to oC, TA1 Trigger
//
//  Description: Use the ADC12's integrated temperature sensor to measure
//  temperature. Sample time is set for 125 ADC12CLK cycles to allow 30us for
//  the integrated temperature sensor (see datasheet). ADC12 is operated in
//  repeat-single-channel mode with the sample and convert trigger sourced
//  from Timer_A CCR1. Timer_A is configured for continuous mode and is clocked
//  by SMCLK. TA1 is set for toggle mode triggering the ADC12 every 125ms.
//  The ADC12MEM0_IFG bit set at the end of each conversion triggers an ISR.
//  Normal mode is LPM0.
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1048576Hz,
//  ADC12CLK = ADC12OSC
//  //* An external watch crystal between XIN & XOUT is required for ACLK *//	
//
//  Uncalibrated temperature measured from device to devive will vary do to
//  slope and offset variance from device to device - please see datasheet.
//
//                MSP430F449
//             -----------------
//         /|\|              XIN|-
//          | |                 | 32KHZ
//          --|RST          XOUT|-
//            |                 |
//            |A10 (Temp)   P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments Inc.
//  Feb 2005
//  Built with CCE Version: 3.2.0 and IAR Embedded Workbench Version: 3.21A
//*****************************************************************************
#include  <msp430x44x.h>

int long temp;
int long IntDegC;
int buf[512];
int i,j = 0;
int count;

void main(void)
{
  int temp;
  
  WDTCTL = WDTPW + WDTHOLD;                 // Stop watchdog timer
//  FLL_CTL0 |= DCOPLUS + XCAP18PF;                     // Configure load caps  

  // Wait for xtal to stabilize
  do
  {
  IFG1 &= ~OFIFG;                           // Clear OSCFault flag
  for (i = 0x47FF; i > 0; i--);             // Time for flag to set
  }
  while ((IFG1 & OFIFG));                   // OSCFault flag still set?

//  SCFI0 = FN_3 | FLLD_4;
//  SCFQCTL = 32 - 1;         
  _BIS_SR(SCG0);                              //  turn off   FLL
  SCFI1 = 0xAF;                                 //  MCLK = DCO  =  0xB0:8.4M  0xAF:8.27M    
  
  P6DIR |= BIT5 | BIT6;
  P6OUT |= BIT5 | BIT6;  
  
  P4DIR |= 0x28;                            // P4.5,4.3 SPI option select UCLK, SIMO
        
  TACTL |= TACLR;                     // Clear Timer_A TAR
  TACTL = TASSEL_2+MC_1;                // SMCLK, up mode
  TACCR0 = 32768;
//  TACCTL0 |= CCIE; 
  TACCTL2 = CM_1+CCIS_1+CAP;            // Pos,CCI1B(Aclk),Cap
  TACCTL2 |= CCIE; 
  _EINT();                                  // Enable interrupts

  i = 0;
  
  while(1)
  {
    LPM0;
    temp = temp<<1;
    temp |= TACCR2&0x0001;
    j++;
    if(j == 15){
      j = 0;
      buf[i++] = temp;
      P6OUT ^= BIT5; 
      P4OUT = temp;      
    }
    TACTL |= TACLR;                     // Clear Timer_A TAR
    if(i==512)
      i = 0;
  }
}

// Timer A1 interrupt service routine
#pragma vector=TIMERA1_VECTOR
__interrupt void Timer_A1 (void)
{
  switch(__even_in_range(TAIV,10)){
  case 4:
    TACCTL2 &= ~CCIFG;                   // interrupt disbled
    LPM0_EXIT;
    break;
  }
}

#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A (void)
{ 
  TACCTL0 &= ~CCIFG;
  P6OUT ^= BIT5;                          
}